/*
* Copyright 2019-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* SPDX-License-Identifier:	GPL-2.0+
*/

#ifndef _RING_CONFIG_H_
#define _RING_CONFIG_H_

#define COCOA_RING_CONFIG_MAGIC 0x4242417e
#define COCOA_RING_CONFIG_VERSION 1

// Configuration header
typedef struct {
	uint32_t magic;
	uint32_t length;
	uint8_t version;
	uint8_t reserved[23];
} ring_config_header;

// Reboot reasons
enum RebootReason
{
	REBOOT_REASON_NORMAL = 0,             // no reason
	REBOOT_REASON_APPLY_OTA = 1,          // Rebooted to recovery to apply ota
	REBOOT_REASON_DONE_OTA = 2,           // Rebooted as normal after applying ota
	REBOOT_REASON_FAILED_OTA = 3,         // Rebooted after failing to apply ota
	REBOOT_REASON_FACTORY_RESET = 4,      // Perform factory reset
	REBOOT_REASON_RECOVERY_STG1_BOOT = 5, // Recovery OTA - stage 1 (create shadow recovery rootfs)
	REBOOT_REASON_RECOVERY_STG2_BOOT = 6, // Recovery OTA - stage 2 (run from shadow rootfs and receive OTA)
	REBOOT_REASON_MAX
};

// Boot configuration for uboot
typedef struct {
	uint8_t recoveryMode;
	uint8_t rebootReason;
	uint8_t recoveryBootCount;
	uint8_t normalBootAttemptCount;  // Incremented by U-Boot, set to 0 after UBI mount in Linux.
	uint8_t reserved[28];
} ring_config_boot;

// Ring configuration data
typedef struct {
	ring_config_header header; // Keep at the start
	ring_config_boot boot;
	uint32_t checksum; // keep at the end
} ring_config;

#endif
